#ifndef _SHADOWSHADER_H_
#define _SHADOWSHADER_H_

#include "BowerShader.h"

using namespace std;
using namespace DirectX;

//Simple shadow shader used to apply shadowing to basic geometry/models
class ShadowShader : public BowerShader
{
	public:
		ShadowShader(ID3D11Device* device, HWND hwnd);
		~ShadowShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, ID3D11ShaderResourceView* texture, ID3D11ShaderResourceView* sunShadowMap, ID3D11ShaderResourceView* spotShadowMap, ID3D11ShaderResourceView* hillShadowMaps[6], float constant, float linear, float quadratic);

	private:
		void initShader(const wchar_t* vs, const wchar_t* ps);

	private:
		ID3D11Buffer* matrixBuffer;
		ID3D11Buffer* lightBuffer;
		ID3D11SamplerState* sampleState;
		ID3D11SamplerState* sampleStateShadow;
};

#endif